<?php
session_start();
require '../includes/config.php';

// Restrict to admins
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: index.php');
    exit;
}

$error = '';
$success = '';

// Fetch roles
$roles_query = "SELECT role_id, role_name FROM roles ORDER BY role_name";
$roles_result = mysqli_query($conn, $roles_query);
$roles = mysqli_fetch_all($roles_result, MYSQLI_ASSOC);

// Create role
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['create_role'])) {
    $role_name = trim($_POST['role_name']);
    
    if (empty($role_name)) {
        $error = "Role name is required.";
    } else {
        $query = "INSERT INTO roles (role_name) VALUES (?)";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, 's', $role_name);
        if (mysqli_stmt_execute($stmt)) {
            $success = "Role created successfully.";
            header('Location: manage_roles.php'); // Refresh to show new role
            exit;
        } else {
            $error = "Failed to create role: " . mysqli_error($conn);
        }
    }
}

// Delete role
if (isset($_GET['delete_role_id'])) {
    $role_id = $_GET['delete_role_id'];
    $query = "DELETE FROM roles WHERE role_id = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 'i', $role_id);
    if (mysqli_stmt_execute($stmt)) {
        $success = "Role deleted successfully.";
        header('Location: manage_roles.php');
        exit;
    } else {
        $error = "Failed to delete role: " . mysqli_error($conn);
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Manage Roles</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../css/manage.css" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h2>Manage Roles</h2>
        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>
        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <!-- Create Role Form -->
        <h3>Create Role</h3>
        <form method="POST">
            <div class="form-group mb-3">
                <label>Role Name</label>
                <input type="text" name="role_name" class="form-control" value="<?php echo isset($_POST['role_name']) ? htmlspecialchars($_POST['role_name']) : ''; ?>" required>
            </div>
            <button type="submit" name="create_role" class="btn btn-primary">Create Role</button>
        </form>

        <!-- Roles List -->
        <h3 class="mt-4">Existing Roles</h3>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Role Name</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($roles)): ?>
                    <tr><td colspan="2">No roles found.</td></tr>
                <?php else: ?>
                    <?php foreach ($roles as $role): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($role['role_name']); ?></td>
                            <td>
                                <a href="edit_role.php?role_id=<?php echo $role['role_id']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                <a href="manage_roles.php?delete_role_id=<?php echo $role['role_id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this role?');">Delete</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
        <a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
    </div>
</body>
</html>