<?php
session_start();
require '../includes/config.php';

// Check if already logged in
if (isset($_SESSION['user_id'])) {
    if ($_SESSION['role'] === 'student') {
        header('Location: student_dashboard.php');
        exit;
    } else {
        header('Location: dashboard.php');
        exit;
    }
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = trim($_POST['id'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (empty($id) || empty($password)) {
        $error = "Please enter both ID and password.";
    } else {
        // Query user
        $query = "SELECT id, first_name, last_name, role, class_id, password 
                  FROM users 
                  WHERE id = ? AND is_deleted = 0";
        $stmt = mysqli_prepare($conn, $query);
        if (!$stmt) {
            $error = "Database error: Unable to process login.";
        } else {
            mysqli_stmt_bind_param($stmt, 's', $id);
            if (!mysqli_stmt_execute($stmt)) {
                $error = "Database error: Failed to execute query.";
            } else {
                $result = mysqli_stmt_get_result($stmt);
                $user = mysqli_fetch_assoc($result);
                mysqli_stmt_close($stmt);

                if ($user && password_verify($password, $user['password'])) {
                    // Set session variables
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['first_name'] = $user['first_name'];
                    $_SESSION['last_name'] = $user['last_name'];
                    $_SESSION['role'] = $user['role'];
                    $_SESSION['class_id'] = $user['class_id'];
                    session_regenerate_id(true);

                    // Redirect based on role
                    if ($user['role'] === 'student') {
                        header('Location: student_dashboard.php');
                        exit;
                    } else {
                        header('Location: dashboard.php');
                        exit;
                    }
                } else {
                    $error = "Invalid ID or password.";
                }
            }
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Login - Appraisal System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="../css/login.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h2>Login to Appraisal System</h2>
        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <form method="POST" class="mt-4">
            <div class="mb-3">
                <label for="id" class="form-label">User ID</label>
                <input type="text" name="id" id="id" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" name="password" id="password" class="form-control" required>
            </div>
            <button type="submit" class="btn-login">Login</button>
        </form>
    </div>
</body>
</html>